/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.instruction.WorldModifyInstruction;
import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

@Environment(value=EnvType.CLIENT)
public class BlockEntityDataInstruction
extends WorldModifyInstruction {
    private final boolean redraw;
    private final UnaryOperator<class_2487> data;
    private final Class<? extends class_2586> type;

    public BlockEntityDataInstruction(Selection selection, Class<? extends class_2586> type, UnaryOperator<class_2487> data, boolean redraw) {
        super(selection);
        this.type = type;
        this.data = data;
        this.redraw = redraw;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderLevel level = scene.getLevel();
        selection.forEach(pos -> {
            if (!level.getBounds().method_14662((class_2382)pos)) {
                return;
            }
            class_2586 blockEntity = level.method_8321((class_2338)pos);
            if (!this.type.isInstance(blockEntity)) {
                return;
            }
            class_5455 registryManager = level.method_30349();
            class_2487 apply = (class_2487)this.data.apply(blockEntity.method_38242((class_7225.class_7874)registryManager));
            try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), Ponder.LOGGER);){
                class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registryManager, (class_2487)apply);
                blockEntity.method_58690(view);
            }
        });
    }

    @Override
    protected boolean needsRedraw() {
        return this.redraw;
    }
}

